#ifndef __HI_CHIP_REGS_H__
#define __HI_CHIP_REGS_H__

#include <mach/io.h>

#define DDR_BASE		0x80000000
#define PCIE1_CONFIG_BASE	0x70000000
#define PCIE1_MEM_BASE		0x60000000
#define SPI_MEM_BASE		0x58000000
#define NAND_MEM_BASE		0x50000000
#define PCIE0_CONFIG_BASE	0x40000000
#define PCIE0_MEM_BASE		0x30000000
#define PCIE1_REG_BASE		0x20810000
#define PCIE0_REG_BASE		0x20800000
#define REG_BASE_L2CACHE	0x20700000
#define BSD_REG_BASE		0x206d0000
#define MD_REG_BASE		0x206c0000
#define VCMP_REG_BASE		0x206b0000
#define VDH1_REG_BASE		0x206a0000
#define VENC1_REG_BASE		0x20690000
#define VPSS1_REG_BASE		0x20680000
#define JPGE_REG_BASE		0x20660000
#define VOIE_REG_BASE		0x20640000
#define VDH0_REG_BASE		0x20630000
#define VENC0_REG_BASE		0x20620000
#define TDE_REG_BASE		0x20610000
#define VPSS0_REG_BASE		0x20600000
#define IVE_REG_BASE		0x205e0000
#define HDMI_REG_BASE		0x205d0000
#define VDP_REG_BASE		0x205c0000
#define VICAP_REG_BASE		0x20580000
#define ARM_DEBUG_BASE		0x20400000
#define ARM_INTNL_BASE		0x20300000
#define GPIO18_BASE		0x20270000
#define GPIO17_BASE		0x20260000
#define GPIO16_BASE		0x20250000
#define GPIO15_BASE		0x20240000
#define GPIO14_BASE		0x20230000
#define GPIO13_BASE		0x20220000
#define GPIO12_BASE		0x20210000
#define GPIO11_BASE		0x20200000
#define GPIO10_BASE		0x201f0000
#define GPIO9_BASE		0x201e0000
#define GPIO8_BASE		0x201d0000
#define GPIO7_BASE		0x201c0000
#define GPIO6_BASE		0x201b0000
#define GPIO5_BASE		0x201a0000
#define GPIO4_BASE		0x20190000
#define GPIO3_BASE		0x20180000
#define GPIO2_BASE		0x20170000
#define GPIO1_BASE		0x20160000
#define GPIO0_BASE		0x20150000
#define TIME3_BASE		0x20140000
#define TIME2_BASE		0x20130000
#define DDRC1_BASE		0x20120000
#define DDRC0_BASE		0x20110000
#define IOCONFIG_BASE		0x200F0000
#define I2C_BASE		0x200d0000
#define SPI_BASE		0x200c0000
#define UART3_BASE		0x200B0000
#define UART2_BASE		0x200A0000
#define UART1_BASE		0x20090000
#define UART0_BASE		0x20080000
#define IR_BASE			0x20070000
#define RTC_BASE		0x20060000
#define SYS_CTRL_BASE		0x20050000
#define WDG_BASE		0x20040000
#define CRG_BASE		0x20030000
#define TIMER1_BASE		0x20010000
#define TIMER0_BASE		0x20000000
#define GMAC_BASE		0x101c0000
#define JPGD_BASE		0x10170000
#define SCD1_BASE		0x10160000
#define SCD0_BASE		0x10150000
#define SIO5_BASE		0x100f0000
#define SIO4_BASE		0x100e0000
#define DMAC_BASE		0x100d0000
#define CIPHER_BASE		0x100c0000
#define USB_EHCI_BASE		0x100b0000
#define USB_OHCI_BASE		0x100a0000
#define SATA_BASE		0x10080000
#define EFUSE_BASE		0x10070000
#define SIO3_BASE		0x10060000
#define SIO2_BASE		0x10050000
#define SIO1_BASE		0x10040000
#define SIO0_BASE		0x10030000
#define SDIO_BASE		0x10020000
#define SPI_REG_BASE		0x10010000
#define NANDC_REG_BASE		0x10000000
#define INTERNAL_RAM_BASE	0x04010000
#define BOOTROM_BASE		0x04000000

#define REG_A9_PERI_SCU                 0x0000
#define REG_A9_PERI_GLOBAL_TIMER        0x0200
#define REG_A9_PERI_PRI_TIMER_WDT       0x0600
#define REG_SC_LOCAL_TIMER              0x600
#define REG_BASE_A9_PERI        ARM_INTNL_BASE

#define A9_GIC_OFFSET		0x100
#define A9_GIC_DIST		0x1000
#define CFG_GIC_CPU_BASE	(IO_ADDRESS(ARM_INTNL_BASE) + A9_GIC_OFFSET)
#define CFG_GIC_DIST_BASE	(IO_ADDRESS(ARM_INTNL_BASE) + A9_GIC_DIST)

#define REG_TIMER_RELOAD        0x000
#define REG_TIMER_VALUE         0x004
#define REG_TIMER_CONTROL       0x008
#define REG_TIMER_INTCLR        0x00C
#define REG_TIMER_RIS           0x010
#define REG_TIMER_MIS           0x014
#define REG_TIMER_BGLOAD        0x018

#define REG_TIMER1_RELOAD	0x020
#define REG_TIMER1_VALUE	0x024
#define REG_TIMER1_CONTROL	0x028
#define REG_TIMER1_INTCLR	0x02C
#define REG_TIMER1_RIS		0x030
#define REG_TIMER1_MIS		0x034
#define REG_TIMER1_BGLOAD	0x038

#define REG_SC_SYSRES		0x4

#define UART_CKSEL_APB		(1 << 13)

#endif
