#ifndef __ASM_ARM_ARCH_IO_H
#define __ASM_ARM_ARCH_IO_H

#define IO_SPACE_LIMIT 0xffffffff

#define __io(a)		__typesafe_io(a)
#define __mem_pci(a)	(a)

#define IO_OFFSET_HIGH 0xEE000000
#define IO_OFFSET_MID 0xE7D00000
#define IO_OFFSET_LOW 0x9E600000

#define GODBOX_IOCH1_VIRT (GODBOX_IOCH1_PHYS + IO_OFFSET_HIGH) /* 0xFE100000 */
#define GODBOX_IOCH1_PHYS 0x10100000 /* 0x10100000 ~ 0x1018FFFF */
#define GODBOX_IOCH1_SIZE 0x90000

#define GODBOX_IOCH2_VIRT (GODBOX_IOCH2_PHYS + IO_OFFSET_HIGH) /* 0xFE1E0000 */
#define GODBOX_IOCH2_PHYS 0x101E0000 /* 0x101E0000 ~ 0x101F0FFF */
#define GODBOX_IOCH2_SIZE 0x13000

#define GODBOX_IOCH3_VIRT (GODBOX_IOCH3_PHYS + IO_OFFSET_HIGH) /* 0xFE1F3000 */
#define GODBOX_IOCH3_PHYS 0x101F3000 /* 0x101F3000 ~ 0x101FFFFF */
#define GODBOX_IOCH3_SIZE 0xE000

#define GODBOX_IOCH4_VIRT (GODBOX_IOCH4_PHYS + IO_OFFSET_HIGH) /* 0xFE201000 */
#define GODBOX_IOCH4_PHYS 0x10201000 /* 0x10201000 ~ 0x1045FFFF*/
#define GODBOX_IOCH4_SIZE 0x260000

#define GODBOX_IOCH5_VIRT (GODBOX_IOCH5_PHYS + IO_OFFSET_MID) /* 0xFE500000 */
#define GODBOX_IOCH5_PHYS 0x16800000 /* 0x16800000 ~ 0x168FFFFF */
#define GODBOX_IOCH5_SIZE 0x100000

#define GODBOX_IOCH6_VIRT (GODBOX_IOCH6_PHYS + IO_OFFSET_LOW) /* 0xFE600000 */
#define GODBOX_IOCH6_PHYS 0x60000000 /* 0x60000000 ~ 0x6014FFFF */
#define GODBOX_IOCH6_SIZE 0x150000

#define GODBOX_IOCH7_VIRT (GODBOX_IOCH7_PHYS + IO_OFFSET_LOW) /* 0xFE750000 */
#define GODBOX_IOCH7_PHYS 0x60150000 /* 0x60150000 ~ 0x6018FFFF */
#define GODBOX_IOCH7_SIZE 0x40000

#define __IO_ADDRESS(x) ((x >= GODBOX_IOCH5_PHYS) ? \
		((x) + IO_OFFSET_MID) : ((x) + IO_OFFSET_HIGH))

#define IO_ADDRESS(x) ((x >= GODBOX_IOCH6_PHYS) ? \
		((x) + IO_OFFSET_LOW) : (__IO_ADDRESS(x)))

#endif
