#ifndef __ASM_ARM_ARCH_IO_H
#define __ASM_ARM_ARCH_IO_H

#define IO_SPACE_LIMIT 0xffffffff

#define __io(a)         __typesafe_io(a)
#define __mem_pci(a)    (a)

#define IO_OFFSET_LOW 0xD1000000
#define IO_OFFSET_HIGH 0xE0000000

/* paddr: 0x10000000 ~ 0x10650000; vaddr: 0xF0000000 ~ 0xF0650000*/
#define PHOENIX_IOCH1_PHYS 0x10000000
#define PHOENIX_IOCH1_VIRT (PHOENIX_IOCH1_PHYS + IO_OFFSET_HIGH)
#define PHOENIX_IOCH1_SIZE 0x650000

/* paddr: 0x1FED0000 ~ 0x20310000; vaddr: 0xF0ED0000 ~ 0xF1310000*/
#define PHOENIX_IOCH2_PHYS 0x1FED0000
#define PHOENIX_IOCH2_VIRT (PHOENIX_IOCH2_PHYS + IO_OFFSET_LOW)
#define PHOENIX_IOCH2_SIZE 0x440000


/* paddr: 0x20700000 ~ 0x20800000; vaddr: 0xF1700000 ~ 0xF1800000*/
#define PHOENIX_IOCH3_PHYS 0x20700000
#define PHOENIX_IOCH3_VIRT (PHOENIX_IOCH3_PHYS + IO_OFFSET_LOW)
#define PHOENIX_IOCH3_SIZE 0x100000

#define IO_ADDRESS(x) ((x) >= PHOENIX_IOCH2_PHYS ? (x) + IO_OFFSET_LOW \
						: (x) + IO_OFFSET_HIGH)

#endif

